<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
	<xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
	<xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
	<xsl:template match="/">
		<xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
		<html>
			<head>
				<link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
				<title lang="en">Výpis Aquaplaning</title>
			</head>
			<body>
				<xsl:choose>
					<xsl:when test="$xslShowHelp = 'true'">
						<xsl:call-template name="StyleSheetHelp"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="InRoads">
							<center>
								<h2 lang="en">Výpis Aquaplaning</h2>
								<p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/>
									<br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
								</p>
								<table class="margin" cellpadding="2" width="80%">
									<td align="center" lang="en" style="font-size: 80%; border-bottom:1px solid black;">
										<strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
										<xsl:if test="//@linearUnits = 'Imperial'">ve stopách,</xsl:if>
										<xsl:if test="//@linearUnits = 'Metric'">v metrech,</xsl:if>
										pokud není specifikováno jinak.
									</td>
								</table>

							</center>
								<xsl:for-each select="FlowLineElements/FlowLineElement">
								<table class="margin" cellpadding="2" width="90%">
									<tbody>
										<tr>
											<th align="right" lang="en">Proudnice Intenzita srážek:&#xa0; </th>
											<td align="left" colspan="2">
												<xsl:if test="//@linearUnits = 'Imperial'"><xsl:value-of select="@RainfallIntensity * 12"/> inch/hour</xsl:if>
												<xsl:if test="//@linearUnits = 'Metric'"><xsl:value-of select="@RainfallIntensity * 1000"/> mm/hour</xsl:if>
											</td>
										</tr>
										<tr>
											<th align="right" lang="en">Hloubka textury:&#xa0; </th>
											<td align="left" colspan="2">
												<xsl:value-of select="@TextureDepth"/>
											</td>
										</tr>
										<tr>
											<th align="right" lang="en">Vzorec:</th>
											<td align="left" colspan="2">
												<xsl:value-of select="@CurrentFormula"/>
											</td>
										</tr>
										<tr>
											<th align="right" lang="en">Použít vyrovnaný sklon plochy?:&#xa0; </th>
											<td align="left" colspan="2">
												<xsl:value-of select="@UsingEqualAreaSlope"/>
											</td>
										</tr>
										<tr>
											<th align="right" lang="en">Název povrchu:&#xa0; </th>
											<td align="left" colspan="2">
												<xsl:value-of select="@SurfaceName"/>
											</td>
										</tr>
									</tbody>
								</table>
								<hr/>
								<!--xsl:for-each select="//FlowlinePoint"-->
									<table cellspacing="4" width="100%">
										<thead style="display:table-header-group">
											<tr>
												<th colspan="8" lang="en">- - - - - - - - Body proudnic - - - - - - -</th>
											</tr>
											<tr>
												<th class="underline" lang="en" valign="bottom">Gallaway Film Hloubka</th>
												<th class="underline" lang="en" valign="bottom">Silniční výzkumná laboratoř Film Hloubka</th>
												<th class="underline" lang="en" valign="bottom">Film Hloubka Rozdíl</th>
												<th class="underline" lang="en" valign="bottom">Sklon (%)</th>
												<th class="underline" lang="en" valign="bottom">Vzdálenost podél</th>
												<th class="underline" lang="en" valign="bottom">Y<sub>s-jtsk</sub></th>
												<th class="underline" lang="en" valign="bottom">X<sub>s-jtsk</sub></th>
												<th class="underline" lang="en" valign="bottom">Z (původní povrch)</th>
											</tr>
										</thead>
										
										<tbody>
											<xsl:for-each select="FlowlinePoint">
												<tr>
													<td align="right">
														<xsl:value-of select="@GallawayFilmDepth"/>
													</td>
													<td align="right">
														<xsl:value-of select="@RRLFilmDepth"/>
													</td>
													<td align="right">
														<xsl:value-of select="@FilmDepthDifference"/>
													</td>
													<td align="right">
														<xsl:value-of select="cif:gradeFormat(number(@Slope))"/>
													</td>
													<td align="right">
														<xsl:value-of select="cif:distanceFormat(number(@DistanceAlong))"/>
													</td>
													<td align="right">
														<xsl:value-of select="cif:ordinateFormat(-1*number(@X))"/>
													</td>
													<td align="right">
														<xsl:value-of select="cif:ordinateFormat(-1*number(@Y))"/>
													</td>
													<td align="right">
														<xsl:value-of select="cif:ordinateFormat(number(@OriginalZ))"/>
													</td>
												</tr>
											</xsl:for-each>
										</tbody>
									</table>
								<!--/xsl:for-each-->
							</xsl:for-each>

						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="StyleSheetHelp">
		<div class="section1">
			<h4 lang="en">Poznámky</h4>
			<p class="normal1" lang="en">
                Pro tento výpis musíte vytvořit nějaký aquaplaning model výběrem <em>
                    OpenRoads Modelování &gt; XML
                    Terén &gt; Aquaplaning
                </em>.
            </p>
			<p class="small" lang="en">
				<em>&#xa9; 2017 Bentley Systems, Inc</em>
			</p>
		</div>
	</xsl:template>
</xsl:stylesheet>
